Imports MicroFour.StrataFrame.Business
Imports MicroFour.StrataFrame.UI.Windows.Forms
Imports MicroFour.StrataFrame.Extensibility
Imports System.ComponentModel
Imports System.Drawing.Design
Imports System.Windows.Forms

Public Class CustomersLookUpControl
    Implements IBusinessBindable


#Region " Constructors "
    Public Sub New()
        Me.InitializeComponent()

        '-- Bind the code to the textbox
        Me.txtCode.DataBindings.Add("Text", Me, "Code", True, DataSourceUpdateMode.OnPropertyChanged)

    End Sub
#End Region

#Region " Events "

    ''' <summary>
    ''' Occurs when the return value of the PrimaryKey property changes.
    ''' </summary>
    ''' <remarks></remarks>
    Public Event CodeChanged As EventHandler

    ''' <summary>
    ''' Raises the CodeChanged event.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overridable Sub OnCodeChanged()
        RaiseEvent CodeChanged(Me, EventArgs.Empty)
    End Sub

    ''' <summary>
    ''' Occurs when the return value of the PrimaryKey property changes.
    ''' </summary>
    ''' <remarks></remarks>
    Public Event PrimaryKeyChanged As EventHandler

    ''' <summary>
    ''' Raises the PrimaryKeyChanged event.
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overridable Sub OnPrimaryKeyChanged()
        RaiseEvent PrimaryKeyChanged(Me, EventArgs.Empty)
    End Sub

#End Region

#Region " Handled Events "

    Private Sub cmdBrowse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdBrowse.Click
        '-- Show the browse dialog
        If CustomersBrowseDialog1.ShowDialog() = DialogResult.OK Then
            Me.txtCode.Text = CustomersBO1.cust_pk.ToString
        End If
    End Sub

#End Region

#Region " IBusinessBindable Implementation "

    Private _BusinessObject As BusinessLayer
    Private _BindingField As String = ""
    Private _BindingFormat As String = ""
    Private _BindingProperty As String = "PrimaryKey"
    Private _IgnoreManageUIReadOnlyState As Boolean = True
    Private _BindingUpdateMode As DataSourceUpdateMode = DataSourceUpdateMode.OnPropertyChanged
    Private _ControlSourceUpdateMode As ControlUpdateMode = ControlUpdateMode.OnPropertyChanged

    ''' <summary>
    ''' The field within the business object that is bound to the control
    ''' </summary>
    <Category(EDITOR_CATEGORY), Description(EDITOR_BINDINGUPDATEMODE_DESC)> _
    Public Property BindingUpdateMode() As DataSourceUpdateMode Implements IBusinessBindable.DataSourceUpdateMode
        Get
            Return _BindingUpdateMode
        End Get
        Set(ByVal value As System.Windows.Forms.DataSourceUpdateMode)
            _BindingUpdateMode = value
        End Set
    End Property

    ''' <summary>
    ''' The field within the business object that is bound to the control
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    <Category(EDITOR_CATEGORY), _
    DefaultValue(""), _
    Description(EDITOR_BINDINGFIELD_DESC), _
    Editor(MicroFour.StrataFrame.Extensibility.Constants.TE_BindingFieldEditor, GetType(UITypeEditor))> _
    Public Property BindingField() As String Implements IBusinessBindable.BindingField
        Get
            Return _BindingField
        End Get
        Set(ByVal value As String)
            _BindingField = value
        End Set
    End Property

    ''' <summary>
    ''' The business object that is used to bind the data to this field
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    <Category(EDITOR_CATEGORY), _
    DefaultValue(CType(Nothing, Object)), _
    Description(EDITOR_BUSINESSOBJECT_DESC)> _
    Public Property BusinessObject() As BusinessLayerBase Implements IBusinessBindable.BusinessObject
        Get
            Return Me._BusinessObject
        End Get
        Set(ByVal value As BusinessLayerBase)
            '-- If the business object is being removed, then make sure it is no longer bound
            If (value Is Nothing) AndAlso (_BusinessObject IsNot Nothing) Then
                Me._BusinessObject.RemoveFromListOfBoundControls(Me)
            End If

            If (Not Me.DesignMode) AndAlso (value IsNot Nothing) Then
                value.AddToListOfBoundControls(Me)
            End If

            _BusinessObject = CType(value, BusinessLayer)
        End Set
    End Property

    ''' <summary>
    ''' The property on this control to which the data is bound.
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    <Category(EDITOR_CATEGORY), _
    DefaultValue("PrimaryKey"), _
    Description(EDITOR_BINDINGPROPERTY_DESC), _
    Editor(MicroFour.StrataFrame.Extensibility.Constants.TE_BindingPropertyEditor, GetType(UITypeEditor))> _
    Public Property BindingProperty() As String Implements IBusinessBindable.BindingProperty
        Get
            Return _BindingProperty
        End Get
        Set(ByVal value As String)
            _BindingProperty = value
        End Set
    End Property

    ''' <summary>
    ''' If True, the control will ignore that auto manage editing state of the business object.  The control will not
    ''' be automatically enabled/disabled by the business object.
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    <Category(EDITOR_CATEGORY), _
    DefaultValue(True), _
    Description(EDITOR_IGNOREMANAGE_DESC)> _
    Public Property IgnoreManageReadOnlyState() As Boolean Implements IBusinessBindable.IgnoreManageUIReadOnlyState
        Get
            Return _IgnoreManageUIReadOnlyState
        End Get
        Set(ByVal value As Boolean)
            _IgnoreManageUIReadOnlyState = value
        End Set
    End Property

    ''' <summary>
    ''' The formst string used to format the data that is bound to the control
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    <Description(EDITOR_BINDINGFORMAT_DESC), Category(EDITOR_CATEGORY), DefaultValue("")> _
    Public Property BindingFormat() As String Implements IBusinessBindable.BindingFormat
        Get
            Return _BindingFormat
        End Get
        Set(ByVal value As String)
            _BindingFormat = value
        End Set
    End Property

    ''' <summary>
    ''' Makes the control available or unavailable for editing
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    <Browsable(False)> _
    Public Property BindingEditable() As Boolean Implements IBusinessBindable.BindingEditable
        Get
            Return Me.Enabled
        End Get
        Set(ByVal value As Boolean)
            Me.Enabled = value
        End Set
    End Property

    ''' <summary>
    ''' Gets or sets a value that determines whether the control will allow
    ''' its editable state to be managed by the bound business object.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Category(EDITOR_CATEGORY), _
    Description(EDITOR_CONTROLUPDATEMODE_DESC)> _
    Public Property ControlSourceUpdateMode() As System.Windows.Forms.ControlUpdateMode Implements IBusinessBindable.ControlSourceUpdateMode
        Get
            Return Me._ControlSourceUpdateMode
        End Get
        Set(ByVal value As System.Windows.Forms.ControlUpdateMode)
            Me._ControlSourceUpdateMode = value
        End Set
    End Property

    Private Sub ResetControlSourceUpdateMode()
        Me._ControlSourceUpdateMode = ControlUpdateMode.OnPropertyChanged
    End Sub

    Private Function ShouldSerializeControlSourceUpdateMode() As Boolean
        Return Me._ControlSourceUpdateMode <> ControlUpdateMode.OnPropertyChanged
    End Function

    ''' <summary>
    ''' Determines if the binding update mode property is set to default
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function ShouldSerializeBindingUpdateMode() As Boolean Implements IBusinessBindable.ShouldSerializeBindingUpdateMode
        Return _BindingUpdateMode <> DataSourceUpdateMode.OnPropertyChanged
    End Function

    ''' <summary>
    ''' Resets the binding update mode
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub ResetBindingUpdateMode() Implements IBusinessBindable.ResetBindingUpdateMode
        _BindingUpdateMode = DataSourceUpdateMode.OnPropertyChanged
    End Sub

#End Region

#Region " Private Fields "

    Private _Code As String = ""
    Private _IsLoading As Boolean = False
    Private _PrimaryKey As Integer = 0

#End Region

#Region " Private Methods "

    ''' <summary>
    ''' Loads the data into the control
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub LoadData(ByVal dataCode As String)
        '-- Incidate that a load is taking place
        _IsLoading = True

        '-- Update the primary key
        PrimaryKey = CInt(dataCode)

        '-- update the text
        Dim lcText As String
        lcText = CustomersBO1.GetFieldValueByPrimaryKey("cust_FirstName", PrimaryKey, False)
        If lcText = String.Empty Then
            lcText = "..."
        End If
        Me.lblDesc.Text = lcText

        '-- Allow updates again
        _IsLoading = False
    End Sub

    ''' <summary>
    ''' Loads the data into the control
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub LoadData(ByVal dataPk As Integer)
        '-- Establish Locals
        Dim dataCode As String = ""

        '-- Indicate that a load is taking place
        _IsLoading = True

        Try
            '-- update the field
            dataCode = dataPk.ToString
            '-- update the text
            Dim lcText As String
            lcText = CustomersBO1.GetFieldValueByPrimaryKey("cust_FirstName", PrimaryKey, False)
            If lcText = String.Empty Then
                lcText = "..."
            End If
            Me.lblDesc.Text = lcText
        Catch ex As Exception
            dataCode = ""
            Me.lblDesc.Text = ""
        End Try

        '-- Update the code
        Code = dataCode

        '-- Allow updates again
        _IsLoading = False
    End Sub

#End Region

#Region " Public Properties "

    ''' <summary>
    ''' The code associated with the loaded record
    ''' </summary>
    Public Property Code() As String
        Get
            Return Me._Code
        End Get
        Set(ByVal value As String)
            If Not value.Equals(_Code) Then
                Me._Code = value

                '-- Determine if the code should be loaded
                If Not _IsLoading Then Me.LoadData(value)

                OnCodeChanged()
            End If
        End Set
    End Property

    ''' <summary>
    ''' The primary key of the currently loaded record
    ''' </summary>
    <Browsable(False)> _
    <DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)> _
    Public Property PrimaryKey() As Integer
        Get
            Return Me._PrimaryKey
        End Get
        Set(ByVal value As Integer)
            If value <> _PrimaryKey Then
                Me._PrimaryKey = value

                '-- Determine if the code should be loaded
                If Not _IsLoading Then Me.LoadData(value)

                OnPrimaryKeyChanged()
            End If
        End Set
    End Property

#End Region

End Class
